﻿var importSampleEditor = {
    mappingData: [],
    context: null,
    respondentVariables: [],
    mappingFields: [],
    mappingDataTable: null,
    allowedFormatExtensions: null,
    refreshMappingTable: function (refreshIndexOnly) {

        
        var ImportLoopMentionMapping = $("#ImportLoopMentionMapping").prop('checked');

        if (ImportLoopMentionMapping) {
            importSampleEditor.mappingData = [];
            importSampleEditor.mappingDataTable.a4datatable("clearTable");
        }
        else {
            var currentPage = importSampleEditor.mappingDataTable.a4datatable("getCurrentPage");

            $.each(importSampleEditor.mappingData, function (i, e) {
                e.index = i;
            })

            if (!refreshIndexOnly) {
                importSampleEditor.mappingDataTable.a4datatable("option", "data", importSampleEditor.mappingData);
                importSampleEditor.mappingDataTable.a4datatable("setCurrentPage", currentPage);
            }
        }

        if (readOnly) {
            $(".v-variableInput input", importSampleEditor.mappingDataTable).a4autocomplete("disable");
            $(".v-fieldInput input", importSampleEditor.mappingDataTable).a4autocomplete("disable");
        }
    },
    initializeMappingDataTable: function (initializeMappingDataTableCallback) {
        importSampleEditor.mappingDataTable = $('.v-FieldVariableMappingTable').a4datatable({
            serverSide: false,
            data: importSampleEditor.mappingData,
            columns: importSampleEditor.getDataTableColumns(),
            toolBarItems: importSampleEditor.getToolBarItems(),
            contextMenuItems: importSampleEditor.getContextMenuItems(),
            displayColumnSelector: false,
            deferRender: false,
            toolBarClick: function (event, data) {
                var action = data.action;
                var rows = data.rows;

                let newMapping =  {
                    variable: "",
                    positionKey: 0,
                    fieldValue: "",
                    positionInput: 0,
                    lengthInput: 0
                };

                if (action == "addVariable") {
                    importSampleEditor.mappingData.push(newMapping);

                    importSampleEditor.mappingDataTable.a4datatable("addRow", [newMapping]);

                    importSampleEditor.refreshMappingTable(true);
                }
                else if (action == "selectVariables") {
                    modalDialog.showWindow(a4.getSurveyAction("VariableSelector", "Shared", { limitRowCount: 0, showEditableSystemVariables: true }), 600, 800, {
                        beforeClose: function () {
                            var variableSelector = $('.fancybox-iframe').contents();
                            var confirmed = variableSelector.find(".v-confirmed").val();
                            if (confirmed) {
                                var variableNames = variableSelector.find('.v-selectedVariables').val();

                                if (variableNames) {
                                    variableNames = variableNames.split(',');
                                    var selectedVariables = [];
                                    var variables = [];

                                    _.each(variableNames, function (variableName) {
                                        if (variableName) {
                                            var variable = _.find(selectedVariables, function (variable) {
                                                return variable.Name == variableName;
                                            });

                                            if (variable)
                                                variables.push(_.pick(variable, "Name", "PositionColumn", "PositionRank", "PositionRecord"));
                                            else
                                                variables.push({ "Name": variableName, "PositionColumn": 1, "PositionRank": 1, "PositionRecord": 1 });
                                        }
                                    });

                                    a4.callServerMethod(a4.getSurveyAction("GetVariableEditorData", "Analyze"), { variables: JSON.stringify(variables) }, function (result) {
                                        if (result) {
                                            var variables = JSON.parse(result);

                                            $.each(variables, function (i, e) {
                                                var variableName = e.IsSystemInfoVariable ? e.DollarName : e.Name;

                                                let newMappingVar = {
                                                    variable: variableName,
                                                    positionKey: 0,
                                                    fieldValue: "",
                                                    positionInput: 0,
                                                    lengthInput: 0
                                                };

                                                importSampleEditor.mappingData.push(newMappingVar);

                                                importSampleEditor.mappingDataTable.a4datatable("addRow", [newMappingVar]);
                                            })

                                            importSampleEditor.refreshMappingTable(true);
                                        }
                                    });
                                }
                            }
                        }
                    });
                }
                else if (action == "preview") {
                    modalDialog.showWindow(a4.getSurveyAction("ImportSamplePreview", "Distribute"), 600, 800);
                }
                else if (action == "delete") {

                    importSampleEditor.deleteMappingRows(rows);
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        importSampleEditor.deleteMappingRows([data.row]);
                        break;
                }
            },
            rowCreated: function (e, d) {
                var nRow = d.row;

                var readonlyAttribute = "";
                if (readOnly) {
                    readonlyAttribute = "disabled=\"disabled\"";
                }

                var variableName = $('.v-variableName', nRow).html();
                var variableInputCell = $('.v-variableInput', nRow);
                variableInputCell.html('<input type="text" value="' + variableName + '" data-index="' + d.index + '" />');
                
                $("input", variableInputCell).a4autocomplete({
                    valueProperty: "Name",
                    labelProperty: "Name",
                    data: importSampleEditor.respondentVariables,
                    select: function (event, data) {
                        var value = data.item ? data.item.Name : undefined;
                        var row = $(this).closest("tr");
                        $(".v-variableName", row).html(value);
                        importSampleEditor.updateMappingRow($(this).attr("data-index"), "variable", value);
                    }
                });

                if (importationFormat == importationFormats.CSV
                    || importationFormat == importationFormats.excel
                    || importationFormat == importationFormats.access) {
                    var fieldValue = $('.v-fieldValue', nRow).html();
                    var fieldInputCell = $('.v-fieldInput', nRow);
                    fieldInputCell.html('<input type="text" value="' + fieldValue + '" data-index="' + d.index + '" />');

                    $("input", fieldInputCell).a4autocomplete({
                        valueProperty: "Position",
                        labelProperty: "Field",
                        data: importSampleEditor.mappingFields,
                        select: function (event, data) {
                            var field = data.item ? data.item.Field : undefined;
                            var position = data.item ? data.item.Position : undefined;
                            var row = $(this).closest("tr");
                            $(".v-fieldValue", row).html(field);
                            $(".v-positionKey", row).html(position);
                            importSampleEditor.updateMappingRow($(this).attr("data-index"), "fieldValue", field);
                            importSampleEditor.updateMappingRow($(this).attr("data-index"), "positionKey", position);
                        }
                    });
                }
                else if (importationFormat == importationFormats.TXT) {
                    var positionInputCell = $('td.v-positionInput', nRow);
                    var LengthInputCell = $('td.v-lengthInput', nRow);

                    var positionValue = positionInputCell.html();
                    var lengthValue = LengthInputCell.html();

                    //if (typeof positionValue === "numeric" && typeof lengthValue === "numeric") {
                    if (!isNaN(positionValue) && !isNaN(lengthValue)) {
                        var readOnlyHTMLAttribute = "";
                        if (readOnly) {
                            readOnlyHTMLAttribute = "disabled=\"disabled\""
                        }

                        positionValue = Number(positionValue) + 1;

                        var positionInput = $("<input type=\"text\" value=\"" + positionValue + "\" class=\"h-positionInput v-validatePositiveInt\" data-min-value=\"1\" " + readOnlyHTMLAttribute + ">");
                        var lengthInput = $("<input type=\"text\" value=\"" + lengthValue + "\" class=\"h-lengthInput v-validatePositiveInt\" " + readOnlyHTMLAttribute + ">");

                        positionInputCell.html(positionInput);
                        LengthInputCell.html(lengthInput);
                    }
                }

                if (readOnly) {
                    var optionsCell = $('.v-itemOptions', nRow);
                    optionsCell.find("a").hide();
                }
            },
            createCallback: initializeMappingDataTableCallback
        });

        $(".v-FieldVariableMappingTable").on("change", ".h-positionInput", function (e) {
            var row = $(this).parents("tr")[0];
            var variableValueCell = $(".v-variableInput input", row);
            importSampleEditor.updateMappingRow(variableValueCell.attr("data-index"), "positionInput", $(this).val());
        });

        $(".v-FieldVariableMappingTable").on("change", ".h-lengthInput", function (e) {
            var row = $(this).parents("tr")[0];
            var variableValueCell = $(".v-variableInput input", row);
            importSampleEditor.updateMappingRow(variableValueCell.attr("data-index"), "lengthInput", $(this).val());
        });

        importSampleEditor.context.on("click", ".h-createRecipientList", function () {
            modalDialog.showWindow(a4.getSurveyAction("CreateRecipientList", "Distribute"), 550, 600, { afterClose: function () { importSampleEditor.reloadRecipientLists(); } });
        });

        $(".v-FieldVariableMappingTable").on("change", ".v-variableInput", function (e) {
            var currentValue = $(this).find("input").attr("data-value");
            if (currentValue == null || currentValue.length == 0) {
                var vName = $(this).parents("tr").find("td.v-variableName");
                $(vName).html("");
            }

        });

    },
    reloadRecipientLists: function () {
        a4.callServerMethod(a4.getSurveyAction("GetRecipientLists", "Distribute"), {}, function (result) {
            var lists = JSON.parse(result);

            if (lists.length > 0) {
                var container = $(".recipient-list .checkbox-list", this.context);
                $(".list-item", container).remove();

                $.each(lists, function (index, value) {
                    var id = "RecipientList_" + (index + 1);
                    var input = $("<input />", { "id": id, "name": "RecipientList", "type": "checkbox", "value": value.Id });
                    var label = $("<label />", { "for": id }).text(value.Label);

                    container.append($("<div />", { "class": "list-item" }).append(input).append(label));
                });
            }
        });
    },
    initializeAutoComplete: function () {
        $(".h-userAutoComplete", $(".v-usersSelectContainer", importSampleEditor.context)).a4autocomplete({
            ajaxAction: a4.getSurveyAction("GetOfflineSurveyUsers", "Analyze"),
            hideSelectedItems: true,
            altValueField: $("#OfflineUserId")
        });
    },
    updateMappingRow: function (idx, key, value) {
        var mapping = _.find(importSampleEditor.mappingData, function (v) { return v.index == idx; });

        if (mapping)
            mapping[key] = value;
    },
    getContextMenuItems: function () {
        var items = [];

        if (!readOnly) {
            items.push({ "Action": "delete", "Label": resources.Delete });
        }

        return items;
    },
    deleteMappingRows: function (rows) {
        var tableRows = new Array();

        _.each(rows, function (i) {
            importSampleEditor.mappingData = _.reject(importSampleEditor.mappingData, function (v) { return v.index == i.index; });
            tableRows.push(i.index);
           
        });

        for (var i = tableRows.length -1; i >= 0; i--)
            importSampleEditor.mappingDataTable.a4datatable("deleteRow", tableRows[i]);
    
        importSampleEditor.refreshMappingTable(true);
        
    },
    getToolBarItems: function () {
        var items = Array();

        if (!readOnly) {
            items.push({ "Action": "addVariable", "Label": resources.addVariable, "AlwaysVisible": true, "DisplayMode": dataTables.itemDisplayMode.always });
            items.push({ "Action": "selectVariables", "Label": resources.selectVariables, "AlwaysVisible": true, "DisplayMode": dataTables.itemDisplayMode.always });
            items.push({ "Action": "preview", "Label": resources.preview, "AlwaysVisible": true, "DisplayMode": dataTables.itemDisplayMode.always });
            items.push({ "Action": "delete", "Label": resources.Delete });
        }

        return items;
    },
    getDataTableColumns: function () {
        var columns = [];

        columns.push({ "Title": "VariableKey", "Data": "variable", "Class": "hidden-column v-variableName", "Sortable": false });
        columns.push({ "Title": resources.variable, "Data": null, "Class": "v-variableInput", "Sortable": false });
        columns.push({ "Title": "PositionKey", "Data": "positionKey", "Class": "hidden-column v-positionKey", "Sortable": false });

        if (importationFormat == importationFormats.CSV
            || importationFormat == importationFormats.excel
            || importationFormat == importationFormats.access) {
            columns.push({ "Title": resources.field, "Data": "fieldValue", "Class": "hidden-column v-fieldValue", "Sortable": false });
            columns.push({ "Title": resources.field, "Data": null, "Class": "v-fieldInput", "Sortable": false });
        }
        else if (importationFormat == importationFormats.TXT) {
            columns.push({ "Title": resources.position, "Data": "positionInput", "Class": "v-positionInput", "Sortable": false });
            columns.push({ "Title": resources.length, "Data": "lengthInput", "Class": "v-lengthInput", "Sortable": false });
        }

        return columns;
    },
    getFieldsMappingRows: function (maxCount) {
        var fieldsMappingRows = [];
        var rows = importSampleEditor.mappingDataTable.a4datatable("getNodes");

        var cpt = 0;
        $.each(rows, function (i, e) {

            if (importationFormat == importationFormats.CSV
            || importationFormat == importationFormats.excel
            || importationFormat == importationFormats.access) {
                var fieldValue = $('.v-fieldValue', e).html();
                var variableValue = $('.v-variableName', e).html();
                var positionValue = $('.v-positionKey', e).html();
            }
            else if (importationFormat == importationFormats.TXT) {
                var variableValue = $('.v-variableName', e).html();
                var positionValue = $('.v-positionInput input', e).val();
                var lengthValue = $('.v-lengthInput input', e).val();
            }

            fieldsMappingRows.push({ Field: fieldValue, Name: variableValue, Position: positionValue, Length: lengthValue });

            if (maxCount != 0) {
                if (cpt < maxCount) {
                    cpt++;
                } else {
                    return false;
                }
            }
        })

        return fieldsMappingRows
    },
    formatHasMappingTable: function () {
        if (importationFormat == importationFormats.CSV
            || importationFormat == importationFormats.excel
            || importationFormat == importationFormats.access
            || importationFormat == importationFormats.TXT) {
            return true;
        }
        else {
            return false;
        }
    },
    setCopyMappings: function () {
        if (importationFormat == importationFormats.CSV
            || importationFormat == importationFormats.excel
            || importationFormat == importationFormats.access) {
            $.each(importSampleEditor.mappingFields, function (i, e) {
                importSampleEditor.mappingData.push({ variable: e.Name, positionKey: e.Position, fieldValue: e.Field });
            });
            importSampleEditor.refreshMappingTable(false);
        }
        else if (importationFormat == importationFormats.TXT) {
            $.each(importSampleEditor.mappingFields, function (i, e) {
                importSampleEditor.mappingData.push({ variable: e.Name, positionKey: e.Position, positionInput: e.Position, lengthInput: e.Length });
            });
            importSampleEditor.refreshMappingTable(false);
        }
    },
    bindEvents: function () {

        $(".h-submitImport").on("click", function () {
            importSampleEditor.submitImport();
        })

        $("#AccessTable").on("change", function () {
            var value = $(this).val();
            var fileName = $(".v-fileUploadSection form").first().attr("data-fname")
            multiFileUpload.refreshFieldsDataTable(fileName, value, null);
        });

        $("#FileDelimiter").on("change", function () {
            var value = $(this).val();
            var fileName = $(".v-fileUploadSection form").first().attr("data-fname")

            if (fileName) {
                multiFileUpload.refreshFieldsDataTable(fileName, null, null);
            }
        });

        $(".v-importationType").on("change", function () {
            var value = $(this).val();
            if (value == "Insert") {
                $(".v-updateResponsesBase").hide();
                $(".v-importAsInactive").show();
                $(".v-firstLineContainsHeader").show();
                $(".v-numberOfCases").show();
                $(".v-pinControl").show();
            } else {
                $(".v-updateResponsesBase").show();
                $(".v-importAsInactive").hide();
                $(".v-firstLineContainsHeader").show();
                $(".v-numberOfCases").hide();
                $(".v-pinControl").hide();
                $("#LinkPanelistType").val("DoNotLink");
            }

            $("#linkPanelistSection").toggle(value == "Insert");
        });

        $(".v-linkPanelistType").on("change", function () {
            var value = $(this).val();

            $("#linkPanelistSection .info").toggle(value == "LinkByUsername");
        });


        $(".v-generatePIN").on("change", function () {
            var checked = $(this).prop('checked');
            if (checked) {
                $(".v-pinMask").show();
            } else {
                $(".v-pinMask").hide();
            }
        });

        $("#ImportLoopMentionMapping").on("change", function () {
            var checked = $(this).prop('checked');
            if (checked) {
                $("#FirstLineContainsHeader").prop("disabled", true);                                
                $("#FirstLineContainsHeader").prop("checked", true);                                
                importSampleEditor.mappingData = [];
                importSampleEditor.mappingDataTable.a4datatable("clearTable");
                $(".v-toolBarButton").addClass("disabled");
                
                
            } else {                
                $("#FirstLineContainsHeader").prop("disabled", false);                                
                $(".v-toolBarButton").removeClass("disabled");
            }
        });
        $("#ImportLoopMentionMapping").trigger("change");

        $('input[name="SchedulingType"]:radio').on("change", function () {
            var value = $(this).val();

            if (value == "ExecuteNow") {
                $(".v-scheduleDateTime").hide();
            } else {
                $(".v-scheduleDateTime").show();
            }
        });

        $(".h-selectOEVariable").on("click", function () {
            modalDialog.showWindow(a4.getSurveyAction("VariableSelector", "Shared", { onlyOpenEnds: true, limitRowCount: 1 }), 600, 800, {
                beforeClose: function () {
                    var variableSelector = $('.fancybox-iframe').contents();
                    var confirmed = variableSelector.find(".v-confirmed").val();
                    if (confirmed) {
                        var value = variableSelector.find('.v-selectedVariables').val();
                        $.each(value.split(","), function (i, e) {
                            $('#VariableName').val(e);
                        })
                    }
                }
            });
        });

        $(".v-PINMaskHelp")
            .on("click", function () {
                $(this).find(".v-text").show();
            })
            .on("mouseleave", function () {
                $(this).find(".v-text").hide();
            });

        $(".h-recipientType").on("change", function () {
            var section = $(this).attr("data-section");
            $(".v-recipientTypeContainer", importSampleEditor.context).hide();
            $(".v-recipientTypeContainer[data-section=" + section + "]", importSampleEditor.context).show();
        });

        importSampleEditor.context.on("keydown", "#EmailAddresses", function () {
            var parent = $(this).closest("div");
            $(".v-emails-count", parent).text(a4.countEmails($(this).val()));
        });

        importSampleEditor.context.on("change", "#EmailAddresses", function () {
            var parent = $(this).closest("div");
            $(".v-emails-count", parent).text(a4.countEmails($(this).val()));
        });
    },
    getConfiguration: function (maxFieldsMappingRowsCount) {
        var importModel = {};

        importModel.format = importationFormat;
        importModel.name = $("#Name", importSampleEditor.context).val();
        importModel.description = $("#Description", importSampleEditor.context).val();
        importModel.importationType = $("#ImportationType", importSampleEditor.context).val();
        importModel.linkPanelistType = $("#LinkPanelistType", importSampleEditor.context).val();
        importModel.duplicateEmailType = $("#DuplicateEmailType", importSampleEditor.context).val();
        importModel.importAsInactive = $("#ImportAsInactive", importSampleEditor.context).is(':checked');
        importModel.numberOfCases = $("#NumberOfCases", importSampleEditor.context).val();
        importModel.generatePIN = $("#GeneratePIN", importSampleEditor.context).is(':checked');
        importModel.pinMask = $("#PinMask", importSampleEditor.context).val();
        importModel.firstLineContainsHeader = $("#FirstLineContainsHeader", importSampleEditor.context).is(':checked');
        importModel.fileDelimiter = $("#FileDelimiter", importSampleEditor.context).val();
        importModel.importStrataQuotaDefinitions = $("#ImportStrataQuotaDefinitions", importSampleEditor.context).val();
        importModel.importCaseHistory = $("#ImportCaseHistory", importSampleEditor.context).val();
        importModel.duplicateCodeBehavior = $("#DuplicateCodeBehavior", importSampleEditor.context).val();
        importModel.accessTable = $("#AccessTable", importSampleEditor.context).val();
        importModel.ConfirmEmail = $("#ConfirmEmail", importSampleEditor.context).is(':checked');
        importModel.VariableName = $("#VariableName", importSampleEditor.context).val();
        importModel.updateResponsesBase = importModel.importationType != "Insert" ? $("#UpdateResponsesBase", importSampleEditor.context).val() : null;
        importModel.ImportationId = $(".v-importationId", importSampleEditor.context).val();
        importModel.RecipientType = $('input[name="RecipientType"]:checked', importSampleEditor.context).val();
        importModel.AutoGenerateQuestions = $("#AutoGenerateQuestions", importSampleEditor.context).is(':checked');
        importModel.EmailAddresses = null;
        importModel.RecipientList = null;
        importModel.ImportLoopMentionMapping = $("#ImportLoopMentionMapping", importSampleEditor.context).is(':checked');
        importModel.DichotomizedMultiple = $("#DichotomizedMultiple", importSampleEditor.context).is(':checked');


        if (importModel.RecipientType == "RecipientLists") {
            importModel.RecipientList = $("input[name='RecipientList']:checked", importSampleEditor.context).map(function () {
                return $(this).attr("value");
            }).get();
        }
        else if (importModel.RecipientType == "Addresses") {
            importModel.EmailAddresses = $("#EmailAddresses", importSampleEditor.context).val();
        }
        importModel.OfflineUserId = $("#OfflineUserId", importSampleEditor.context).val();

        if (importationFormat == importationFormats.CSV
            || importationFormat == importationFormats.excel
            || importationFormat == importationFormats.access
            || importationFormat == importationFormats.TXT) {
            importModel.FieldsMappingRows = importSampleEditor.getFieldsMappingRows(maxFieldsMappingRowsCount);
        }

        importModel.FileNames = [];
        $("#fileUploadContainer .h-fileUploadField.uploaded").each(function (i, e) {
            importModel.FileNames.push($(this).attr("data-fname"));
        })

        return importModel;
    },
    submitImport: function () {
        var importModel = importSampleEditor.getConfiguration(0);

        if (importSampleEditor.validateRequiredFields() && importSampleEditor.validateFieldMappingRows(importModel) &&
            importSampleEditor.validateFiles()) {
            a4.callServerMethod(a4.getSurveyAction("ImportSampleWizard", "Distribute"), importModel,
			    function (result) {
			        a4.parent().importSample.refreshDataTable();
			        modalDialog.close();
			    },
			    function (error) {
			        a4.onAjaxPageMethodError(error);
			    }
		    );
        }
    },
    recalculateMappings: function () {

        importSampleEditor.mappingData = [];

        $.each(importSampleEditor.mappingFields, function (i, e) {
            var fieldName = e.Field;
            var position = e.Position;
            var autoMapping = e.AutoMapping;
            importSampleEditor.mappingData.push({ variable: autoMapping, positionKey: position, fieldValue: fieldName });
        });
        importSampleEditor.refreshMappingTable(false);
    },
    setDatePickers: function () {
        $("#ScheduleDateTime").datetimepicker({
            stepMinute: 5
        });
    },
    validateRequiredFields: function () {
        var errorMessage = resources.requiredError;
        var requiredFields = $(":input.v-requiredField:visible:enabled", importSampleEditor.context);
        var isValid = true;

        requiredFields.removeClass("input-validation-error");
        $(".field-validation-error", importSampleEditor.context).addClass("field-validation-valid").removeClass("field-validation-error").text("");

        requiredFields.each(function () {
            if ($.trim($(this).val()).length == 0) {
                isValid = false;
                var error = $("[data-valmsg-for='" + $(this).attr("name") + "']", importSampleEditor.context);

                $(this).addClass("input-validation-error");
                error.removeClass("field-validation-valid").addClass("field-validation-error").text(errorMessage);
            }
        });

        if (importationFormat == importationFormats.openEndForCoding) {
            var $variableControl = $("#VariableName")
            if ($.trim($variableControl.val()).length == 0) {
                isValid = false;
                var error = $("[data-valmsg-for='" + $variableControl.attr("name") + "']", importSampleEditor.context);

                $variableControl.addClass("input-validation-error");
                error.removeClass("field-validation-valid").addClass("field-validation-error").text(errorMessage);
            }
        }

        return isValid;
    },
    validateFieldMappingRows: function (model) {
        var isValid = true;

        if (!model.AutoGenerateQuestions) {
            if (importationFormat == importationFormats.CSV
                || importationFormat == importationFormats.excel
                || importationFormat == importationFormats.access) {
                var verifiedValues = [];

                $.each(model.FieldsMappingRows, function (i, e) {
                    if ($.trim(e.Name).length == 0
                        || $.trim(e.Field).length == 0
                        || verifiedValues.indexOf($.trim(e.Name)) !== -1) {
                        a4.showErrorMessage(resources.mappingError);
                        isValid = false;
                        return false;
                    }
                    verifiedValues.push(e.Name);
                });
            }
            else if (importationFormat == importationFormats.TXT) {
                $.each(model.FieldsMappingRows, function (i, e) {
                    if ($.trim(e.Name).length == 0
                        || $.trim(e.Position).length == 0
                        || $.trim(e.Length).length == 0) {
                        a4.showErrorMessage(resources.mappingError);
                        isValid = false;
                        return false;
                    }
                });
            }
        }

        return isValid;
    },
    validateFiles: function (rows) {
        var isValid = true;

        if (importationFormat != importationFormats.openEndForCoding && importationFormat != importationFormats.caseGenerator) {
            var numFiles = $("#fileUploadContainer form.file-upload-field.uploaded").length;
            if (numFiles <= 0) {
                a4.showErrorMessage(resources.fileInputError);
                isValid = false;
            }
        }

        return isValid;
    },
    setValidateNumbersEvents: function (context) {
        $(importSampleEditor.context).on("keydown", ".v-validatePositiveInt", function (event) {
            a4.validateNumberKeyCode(event, false);
        });

        $(importSampleEditor.context).on("change", ".v-validatePositiveInt, .v-validateInt, .v-validateLong", function (event) {
            var value = parseInt($(this).val(), 10);

            if (!isNaN(value)) {
                var newValue = 0;

                if ($(this).hasClass("v-validatePositiveInt")) {
                    newValue = validateInt32Bounds(value, $(this).attr("data-min-value"), $(this).attr("data-max-value"), true);
                }
                else if ($(this).hasClass("v-validateInt")) {
                    newValue = validateInt32Bounds(value, $(this).attr("data-min-value"), $(this).attr("data-max-value"), false);
                }
                else {
                    newValue = validateInt64Bounds(value, $(this).attr("data-min-value"), $(this).attr("data-max-value"), false);
                }

                if (value !== newValue) {
                    $(this).val(newValue).trigger('change');
                }
            }
            else {
                $(this).val('');
            }
        });
    },
    setFormElementsReadOnly: function () {

        $(".v-fileUploadSection form").each(function () {
            $(this).find(".h-deleteFile").hide();
        });
    }
}

var multiFileUpload = {
    container: null,
    uploadFields: null,
    uploadFieldModel: null,
    multipleFiles: false,
    initialize: function () {
        multiFileUpload.container = $("#fileUploadContainer");
        multiFileUpload.uploadFieldModel = $('<form class="file-upload-field h-fileUploadField"><input name="file" type="file" /><span class=\"v-allowedExtensions\"></span><span class="file-name v-fileName"></span>' + voxco.icons.getIcon("remove", "h-deleteFile delete-file-button") + voxco.icons.getIcon("loading", "upload-sample-spin") + '</form>')
        multiFileUpload.showAllowedExtensions(multiFileUpload.uploadFieldModel);

        if (sourceFileName != "")
        {
            var originalFileName = sourceFileName.substring(sourceFileName.indexOf("_", sourceFileName.indexOf("_") + 1) + 1);
            var uploadField = multiFileUpload.uploadFieldModel.clone();
            uploadField.attr("data-fname", sourceFileName);
            uploadField.removeClass("uploading");
            uploadField.addClass("uploaded");
            uploadField.find(".v-fileName").html(originalFileName);
            multiFileUpload.container.prepend(uploadField);

            if (multiFileUpload.multipleFiles && !readOnly) {
                multiFileUpload.addNewUploadField();
            }

            if (importSampleEditor.formatHasMappingTable()) {
                if (!readOnly) {
                    var selectedTable = importationFormat == importationFormats.access ? $("#AccessTable").val() : null;

                    if (importationId == 0 && (!importSampleEditor.mappingFields || importSampleEditor.mappingFields.length == 0)) {
                        multiFileUpload.refreshFieldsDataTable(sourceFileName, selectedTable, null);//: function (fileName, selectedValue)
                    }
                }
            }

            multiFileUpload.container.find(".v-allowedExtensions").hide();
        }
        else
        {
            //Create initial upload field
            //var uploadField = multiFileUpload.uploadFieldModel.clone();
            if (!readOnly)
                multiFileUpload.addNewUploadField();
        }
    },
    bindEvents: function () {
        multiFileUpload.container.on("change", ".h-fileUploadField input", function () {
            var uploadContainerForm = $(this).closest(".h-fileUploadField");
            var filename = $(this).val().split('\\').pop();
            var extension = filename.split('.').pop();
            uploadContainerForm.find(".upload-sample-spin").show();

            var showUploadErrorMessage = function (error) {
                uploadContainerForm.remove();
                multiFileUpload.addNewUploadField();
                a4.showErrorMessage(error);
            } 

            if (importSampleEditor.allowedFormatExtensions.indexOf(extension.toLowerCase()) > -1) {
                uploadContainerForm.addClass("uploading");

                var dataForm = new FormData(uploadContainerForm.get(0));

                $.ajax({
                    type: "POST",
                    url: a4.getSurveyAction("ImportSampleUploadFile", "Distribute"),
                    headers: { "X-CSRF-TOKEN": $(aft).val() },
                    data: dataForm,
                    async: false,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function (result) {
                        if (result.startsWith("Error:")) {
                            showUploadErrorMessage(result.replace("Error:", ""));
                            return;
                        }

                        uploadContainerForm.attr("data-fname", result);
                        uploadContainerForm.find(".v-allowedExtensions").hide();

                        callback = function () {
                            uploadContainerForm.removeClass("uploading");
                            uploadContainerForm.addClass("uploaded");
                            uploadContainerForm.find(".upload-sample-spin").hide();
                        };

                        if (importationFormat == importationFormats.CSV
                            || importationFormat == importationFormats.excel) {
                            multiFileUpload.refreshFieldsDataTable(result, null, callback);
                        } else if (importationFormat == importationFormats.TXT) {
                            importSampleEditor.mappingData = [];
                            importSampleEditor.mappingDataTable.a4datatable("clearTable");
                            callback();
                        } else if (importationFormat == importationFormats.access) {
                            multiFileUpload.refreshAccessTablesField(result, callback);
                        } else {
                            callback();
                        }
                    },
                    error: function (xhr, status, error) {
                        if (xhr.status == 413) {
                            showUploadErrorMessage(resources.fileTooLarge);
                        } else {
                            showUploadErrorMessage(resources.unexpectedError);
                        }
                    }
                });

                $(".v-fileName", uploadContainerForm).html(filename);

                if (multiFileUpload.multipleFiles) {
                    multiFileUpload.addNewUploadField();
                }
            } else {
                showUploadErrorMessage(resources.wrongFileExtension);
            }
        });

        multiFileUpload.container.on("click", ".h-deleteFile", function () {
            var uploadContainerForm = $(this).closest(".h-fileUploadField");
            var filePath = uploadContainerForm.attr("data-fname");

            var args = { filePath: filePath };

            if (filePath != null && filePath !== "") {
                a4.callServerMethod(a4.getSurveyAction("DeleteUploadedFile", "Distribute"), args,
			        function (result) {
			            uploadContainerForm.remove();

			            if (importSampleEditor.mappingDataTable) {
			                importSampleEditor.mappingData = [];
			                importSampleEditor.mappingDataTable.a4datatable("clearTable");
			            }

			            if (importationFormat == importationFormats.access) {
			                $('#AccessTable')
                                .find('option')
                                .remove()
			                ;
			            }
			        },
			        function (error) {
			            a4.onAjaxPageMethodError(error);
			        }
			    );
            }

            if (!multiFileUpload.multipleFiles) {
                multiFileUpload.addNewUploadField();
            }
        });
    },
    refreshFieldsDataTable: function (fileName, selectedValue, callback) {

        var args = { fileName: fileName, format: importationFormat, selectedValue: selectedValue };

        if (importationFormat == importationFormats.CSV) {
            args.delimiter = $("#FileDelimiter").val();
        }

        a4.callServerMethod(a4.getSurveyAction("GetDataMappingFields", "Distribute"), args,
			function (result) {
			    if (result !== null) {
			        importSampleEditor.mappingFields = result;
			        importSampleEditor.recalculateMappings();

			        if (callback) {
			            callback();
			        }
			    }
			},
			function (error) {
			    a4.onAjaxPageMethodError(error);
			}
		);
    },
    refreshAccessTablesField: function (fileName, callback) {
        a4.callServerMethod(a4.getSurveyAction("GetAccessTables", "Distribute"), { fileName: fileName },
			function (result) {

			    if (result) {
			        $("#AccessTable").empty();
			        for (var i = 0, l = result.length; i < l; i++) {
			            var val = result[i];
			            $("#AccessTable").append("<option value=\"" + val + "\">" + val + "</option>");
			        }
			        $("#AccessTable").trigger("change");
			    }

			    if (callback) {
			        callback();
			    }
			},
			function (error) {
			    a4.onAjaxPageMethodError(error);
			}
		);
    },
    addNewUploadField: function () {
        var uploadField = multiFileUpload.uploadFieldModel.clone();
        multiFileUpload.container.prepend(uploadField);
        multiFileUpload.showAllowedExtensions(uploadField);
    },
    showAllowedExtensions: function (context) {
        if (importSampleEditor.allowedFormatExtensions != null) {
            $(".v-allowedExtensions", context).html(" (" + importSampleEditor.allowedFormatExtensions.join(", ") + ")");
        }
    }
}

$(document).ready(function () {
    importSampleEditor.context = $("#importSampleWizard");
    importSampleEditor.respondentVariables = respondentImportVariables;
    importSampleEditor.allowedFormatExtensions = allowedFormatExtensions[importationFormat];

    $(":input.v-requiredField:visible:enabled", importSampleEditor.context).each(function () {
        var parent = $(this).closest(".section");
        $(".title", parent).addClass("required");
    });
    
    new Promise(function(resolve) {
        if (importSampleEditor.formatHasMappingTable()) {
            importSampleEditor.initializeMappingDataTable(resolve);
        } else {
            resolve();
        }
    }).then(function() {
        multiFileUpload.initialize();
        multiFileUpload.bindEvents();

        importSampleEditor.setCopyMappings();
        importSampleEditor.bindEvents();
        importSampleEditor.setDatePickers();
        importSampleEditor.setValidateNumbersEvents();
        importSampleEditor.initializeAutoComplete();

        if (readOnly) {
            importSampleEditor.setFormElementsReadOnly();
        }

        switch (importationFormat) {
        case "Acuity4Survey":
            multiFileUpload.multipleFiles = true;
            break;
        case "CommandCenter":
            multiFileUpload.multipleFiles = true;
            break;
        default:
            multiFileUpload.multipleFiles = false;
        }
    } );
});